@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
 * @property values The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
 */
public data class EcsInstanceSetExcludeInstanceFilter(
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.EcsInstanceSetExcludeInstanceFilter): EcsInstanceSetExcludeInstanceFilter = EcsInstanceSetExcludeInstanceFilter(
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
