@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of ENI.
 * @property networkInterfaceName The name of ENI.
 * @property primaryIpAddress The primary private IP address of ENI.
 * @property securityGroupId The ID of the security group to which to assign secondary ENI.
 * @property vswitchId The ID of the vSwitch to which to connect ENI.
 */
public data class EcsInstanceSetNetworkInterface(
    public val description: String? = null,
    public val networkInterfaceName: String? = null,
    public val primaryIpAddress: String? = null,
    public val securityGroupId: String,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.EcsInstanceSetNetworkInterface): EcsInstanceSetNetworkInterface = EcsInstanceSetNetworkInterface(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            networkInterfaceName = javaType.networkInterfaceName().map({ args0 -> args0 }).orElse(null),
            primaryIpAddress = javaType.primaryIpAddress().map({ args0 -> args0 }).orElse(null),
            securityGroupId = javaType.securityGroupId(),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
