@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of the disk.
 * @property deleteWithInstance Indicates whether the data disk is released with the instance.
 * @property description The description of the data disk.
 * @property encrypted Encrypted the data in this disk.
 * @property name The name of the data disk.
 * @property performanceLevel The performance level of the ESSD used as the data disk.
 * @property size The size of the data disk.
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class EcsLaunchTemplateDataDisk(
    public val category: String? = null,
    public val deleteWithInstance: Boolean? = null,
    public val description: String? = null,
    public val encrypted: Boolean? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val size: Int? = null,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.EcsLaunchTemplateDataDisk): EcsLaunchTemplateDataDisk = EcsLaunchTemplateDataDisk(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            deleteWithInstance = javaType.deleteWithInstance().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
