@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The ENI description.
 * @property name The ENI name.
 * @property primaryIp The primary private IP address of the ENI.
 * @property securityGroupId The security group ID must be one in the same VPC.
 * @property vswitchId The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
 */
public data class EcsLaunchTemplateNetworkInterfaces(
    public val description: String? = null,
    public val name: String? = null,
    public val primaryIp: String? = null,
    public val securityGroupId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.EcsLaunchTemplateNetworkInterfaces): EcsLaunchTemplateNetworkInterfaces = EcsLaunchTemplateNetworkInterfaces(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            primaryIp = javaType.primaryIp().map({ args0 -> args0 }).orElse(null),
            securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
