@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
 * @property deleteWithInstance Specifies whether to release the system disk when the instance is released. Default to `true`.
 * @property description System disk description. It cannot begin with http:// or https://.
 * @property encrypted Specifies whether the system disk is encrypted.
 * @property iops The Iops.
 * @property name System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
 * @property performanceLevel The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
 * @property size Size of the system disk, measured in GB. Value range: [20, 500].
 */
public data class EcsLaunchTemplateSystemDisk(
    public val category: String? = null,
    public val deleteWithInstance: Boolean? = null,
    public val description: String? = null,
    public val encrypted: Boolean? = null,
    public val iops: String? = null,
    public val name: String? = null,
    public val performanceLevel: String? = null,
    public val size: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.EcsLaunchTemplateSystemDisk): EcsLaunchTemplateSystemDisk = EcsLaunchTemplateSystemDisk(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            deleteWithInstance = javaType.deleteWithInstance().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
