@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property activationId The ID of the activation code.
 * @property createTime The time when the activation code was created.
 * @property deregisteredCount The number of instances that have been logged out.
 * @property description Description of the corresponding activation code.
 * @property disabled Indicates whether the activation code is disabled.
 * @property id The ID of the Activation.
 * @property instanceCount The maximum number of times the activation code is used to register a managed instance.
 * @property instanceName The default prefix of the instance name.
 * @property ipAddressRange The IP address of the host that allows the activation code to be used.
 * @property registeredCount The number of instances that were registered.
 * @property timeToLiveInHours The validity period of the activation code. Unit: hours.
 */
public data class GetActivationsActivation(
    public val activationId: String,
    public val createTime: String,
    public val deregisteredCount: Int,
    public val description: String,
    public val disabled: Boolean,
    public val id: String,
    public val instanceCount: Int,
    public val instanceName: String,
    public val ipAddressRange: String,
    public val registeredCount: Int,
    public val timeToLiveInHours: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetActivationsActivation): GetActivationsActivation = GetActivationsActivation(
            activationId = javaType.activationId(),
            createTime = javaType.createTime(),
            deregisteredCount = javaType.deregisteredCount(),
            description = javaType.description(),
            disabled = javaType.disabled(),
            id = javaType.id(),
            instanceCount = javaType.instanceCount(),
            instanceName = javaType.instanceName(),
            ipAddressRange = javaType.ipAddressRange(),
            registeredCount = javaType.registeredCount(),
            timeToLiveInHours = javaType.timeToLiveInHours(),
        )
    }
}
