@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getActivations.
 * @property activations
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceName
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property totalCount
 */
public data class GetActivationsResult(
    public val activations: List<GetActivationsActivation>,
    public val id: String,
    public val ids: List<String>,
    public val instanceName: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetActivationsResult): GetActivationsResult = GetActivationsResult(
            activations = javaType.activations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetActivationsActivation.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            totalCount = javaType.totalCount(),
        )
    }
}
