@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property autoSnapshotPolicyId The ID of the Auto Snapshot Policy.
 * @property copiedSnapshotsRetentionDays The retention period of the snapshot copied across regions.
 * @property diskNums The number of disks to which the automatic snapshot policy is applied.
 * @property enableCrossRegionCopy Specifies whether to enable the system to automatically copy snapshots across regions.
 * @property id The ID of the Auto Snapshot Policy.
 * @property name The snapshot policy name..
 * @property repeatWeekdays The automatic snapshot repetition dates.
 * @property retentionDays The snapshot retention time, and the unit of measurement is day.
 * @property status The status of Auto Snapshot Policy.
 * @property tags A mapping of tags to assign to the resource.
 * @property targetCopyRegions The destination region to which the snapshot is copied.
 * @property timePoints The automatic snapshot creation schedule, and the unit of measurement is hour.
 * @property volumeNums The number of extended volumes on which this policy is enabled.
 */
public data class GetAutoSnapshotPoliciesPolicy(
    public val autoSnapshotPolicyId: String,
    public val copiedSnapshotsRetentionDays: Int,
    public val diskNums: Int,
    public val enableCrossRegionCopy: Boolean,
    public val id: String,
    public val name: String,
    public val repeatWeekdays: List<String>,
    public val retentionDays: Int,
    public val status: String,
    public val tags: Map<String, String>,
    public val targetCopyRegions: List<String>,
    public val timePoints: List<String>,
    public val volumeNums: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetAutoSnapshotPoliciesPolicy): GetAutoSnapshotPoliciesPolicy = GetAutoSnapshotPoliciesPolicy(
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId(),
            copiedSnapshotsRetentionDays = javaType.copiedSnapshotsRetentionDays(),
            diskNums = javaType.diskNums(),
            enableCrossRegionCopy = javaType.enableCrossRegionCopy(),
            id = javaType.id(),
            name = javaType.name(),
            repeatWeekdays = javaType.repeatWeekdays().map({ args0 -> args0 }),
            retentionDays = javaType.retentionDays(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetCopyRegions = javaType.targetCopyRegions().map({ args0 -> args0 }),
            timePoints = javaType.timePoints().map({ args0 -> args0 }),
            volumeNums = javaType.volumeNums(),
        )
    }
}
