@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property capacityReservationId Capacity Reservation id
 * @property capacityReservationName Capacity reservation service name.
 * @property description description of the capacity reservation instance
 * @property endTime end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
 * @property endTimeType Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
 * @property id The ID of the Capacity Reservation.
 * @property instanceAmount The total number of instances that need to be reserved within the capacity reservation
 * @property instanceType Instance type. Currently, you can only set the capacity reservation service for one instance type.
 * @property matchCriteria The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
 * @property paymentType The payment type of the resource. value range `PostPaid`, `PrePaid`.
 * @property platform platform of the capacity reservation , value range `windows`, `linux`, `all`.
 * @property resourceGroupId The resource group id.
 * @property startTime time of the capacity reservation which become active
 * @property startTimeType The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
 * @property status The status of the capacity reservation. value range `All`, `Pending`, `Preparing`, `Prepared`, `Active`, `Released`.
 * @property tags The tag of the resource.
 * @property timeSlot This parameter is under test and is not yet open for use.
 * @property zoneIds The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
 */
public data class GetCapacityReservationsReservation(
    public val capacityReservationId: String,
    public val capacityReservationName: String,
    public val description: String,
    public val endTime: String,
    public val endTimeType: String,
    public val id: String,
    public val instanceAmount: String,
    public val instanceType: String,
    public val matchCriteria: String,
    public val paymentType: String,
    public val platform: String,
    public val resourceGroupId: String,
    public val startTime: String,
    public val startTimeType: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val timeSlot: String,
    public val zoneIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetCapacityReservationsReservation): GetCapacityReservationsReservation = GetCapacityReservationsReservation(
            capacityReservationId = javaType.capacityReservationId(),
            capacityReservationName = javaType.capacityReservationName(),
            description = javaType.description(),
            endTime = javaType.endTime(),
            endTimeType = javaType.endTimeType(),
            id = javaType.id(),
            instanceAmount = javaType.instanceAmount(),
            instanceType = javaType.instanceType(),
            matchCriteria = javaType.matchCriteria(),
            paymentType = javaType.paymentType(),
            platform = javaType.platform(),
            resourceGroupId = javaType.resourceGroupId(),
            startTime = javaType.startTime(),
            startTimeType = javaType.startTimeType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeSlot = javaType.timeSlot(),
            zoneIds = javaType.zoneIds().map({ args0 -> args0 }),
        )
    }
}
