@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCapacityReservations.
 * @property capacityReservationIds
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Capacity Reservation IDs.
 * @property instanceType Instance type. Currently, you can only set the capacity reservation service for one instance type.
 * @property nameRegex
 * @property names A list of name of Capacity Reservations.
 * @property outputFile
 * @property paymentType The payment type of the resource
 * @property platform platform of the capacity reservation.
 * @property reservations A list of Capacity Reservation Entries. Each element contains the following attributes:
 * @property resourceGroupId The resource group id
 * @property status The status of the capacity reservation.
 * @property tags A mapping of tags to assign to the Capacity Reservation.
 */
public data class GetCapacityReservationsResult(
    public val capacityReservationIds: List<String>? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceType: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val platform: String? = null,
    public val reservations: List<GetCapacityReservationsReservation>,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetCapacityReservationsResult): GetCapacityReservationsResult = GetCapacityReservationsResult(
            capacityReservationIds = javaType.capacityReservationIds().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            platform = javaType.platform().map({ args0 -> args0 }).orElse(null),
            reservations = javaType.reservations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetCapacityReservationsReservation.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
