@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commandContent The Base64-encoded content of the command.
 * @property commandId The ID of the Command.
 * @property description The description of command.
 * @property enableParameter Specifies whether to use custom parameters in the command to be created.
 * @property id The ID of the Command.
 * @property name The name of the command
 * @property parameterNames A list of custom parameter names which are parsed from the command content specified when the command was being created.
 * @property timeout The timeout period that is specified for the command to be run on ECS instances.
 * @property type The command type.
 * @property workingDir The execution path of the command in the ECS instance.
 */
public data class GetCommandsCommand(
    public val commandContent: String,
    public val commandId: String,
    public val description: String,
    public val enableParameter: Boolean,
    public val id: String,
    public val name: String,
    public val parameterNames: List<String>,
    public val timeout: Int,
    public val type: String,
    public val workingDir: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetCommandsCommand): GetCommandsCommand = GetCommandsCommand(
            commandContent = javaType.commandContent(),
            commandId = javaType.commandId(),
            description = javaType.description(),
            enableParameter = javaType.enableParameter(),
            id = javaType.id(),
            name = javaType.name(),
            parameterNames = javaType.parameterNames().map({ args0 -> args0 }),
            timeout = javaType.timeout(),
            type = javaType.type(),
            workingDir = javaType.workingDir(),
        )
    }
}
