@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCommands.
 * @property commandProvider
 * @property commands
 * @property contentEncoding
 * @property description
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property name
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property type
 */
public data class GetCommandsResult(
    public val commandProvider: String? = null,
    public val commands: List<GetCommandsCommand>,
    public val contentEncoding: String? = null,
    public val description: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetCommandsResult): GetCommandsResult = GetCommandsResult(
            commandProvider = javaType.commandProvider().map({ args0 -> args0 }).orElse(null),
            commands = javaType.commands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetCommandsCommand.Companion.toKotlin(args0)
                })
            }),
            contentEncoding = javaType.contentEncoding().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
