@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property actionOnMaintenance The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online.
 * @property autoPlacement Specifies whether to add the dedicated host to the resource pool for automatic deployment.
 * @property autoReleaseTime The automatic release time of the dedicated host.
 * @property capacities (Available in 1.123.1+) A collection of proprietary host performance indicators.
 * @property cores A mapping of tags to assign to the resource.
 * @property cpuOverCommitRatio (Available in 1.123.1+) CPU oversold ratio.
 * @property dedicatedHostId The ID of ECS Dedicated Host.
 * @property dedicatedHostName The name of ECS Dedicated Host.
 * @property dedicatedHostType The type of the dedicated host.
 * @property description The description of the dedicated host.
 * @property expiredTime The expiration time of the subscription dedicated host.
 * @property gpuSpec The GPU model.
 * @property id ID of the ECS Dedicated Host.
 * @property machineId The machine code of the dedicated host.
 * @property networkAttributes dedicated host network parameters. contains the following attributes:
 * @property operationLocks The reason why the dedicated host resource is locked.
 * @property paymentType The billing method of the dedicated host.
 * @property physicalGpus The number of physical GPUs.
 * @property resourceGroupId The ID of the resource group to which the ECS Dedicated Host belongs.
 * @property saleCycle The unit of the subscription billing method.
 * @property sockets The number of physical CPUs.
 * @property status The status of the ECS Dedicated Host. validate value: `Available`, `Creating`, `PermanentFailure`, `Released`, `UnderAssessment`.
 * @property supportedCustomInstanceTypeFamilies (Available in 1.123.1+) A custom instance type family supported by a dedicated host.
 * @property supportedInstanceTypeFamilies (Available in 1.123.1+) ECS instance type family supported by the dedicated host.
 * @property supportedInstanceTypesLists The list of ECS instance
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The zone ID of the ECS Dedicated Host.
 */
public data class GetDedicatedHostsHost(
    public val actionOnMaintenance: String,
    public val autoPlacement: String,
    public val autoReleaseTime: String,
    public val capacities: List<GetDedicatedHostsHostCapacity>,
    public val cores: Int,
    public val cpuOverCommitRatio: Double,
    public val dedicatedHostId: String,
    public val dedicatedHostName: String,
    public val dedicatedHostType: String,
    public val description: String,
    public val expiredTime: String,
    public val gpuSpec: String,
    public val id: String,
    public val machineId: String,
    public val networkAttributes: List<GetDedicatedHostsHostNetworkAttribute>,
    public val operationLocks: List<GetDedicatedHostsHostOperationLock>,
    public val paymentType: String,
    public val physicalGpus: Int,
    public val resourceGroupId: String,
    public val saleCycle: String,
    public val sockets: Int,
    public val status: String,
    public val supportedCustomInstanceTypeFamilies: List<String>,
    public val supportedInstanceTypeFamilies: List<String>,
    public val supportedInstanceTypesLists: List<String>,
    public val tags: Map<String, String>,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetDedicatedHostsHost): GetDedicatedHostsHost = GetDedicatedHostsHost(
            actionOnMaintenance = javaType.actionOnMaintenance(),
            autoPlacement = javaType.autoPlacement(),
            autoReleaseTime = javaType.autoReleaseTime(),
            capacities = javaType.capacities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsHostCapacity.Companion.toKotlin(args0)
                })
            }),
            cores = javaType.cores(),
            cpuOverCommitRatio = javaType.cpuOverCommitRatio(),
            dedicatedHostId = javaType.dedicatedHostId(),
            dedicatedHostName = javaType.dedicatedHostName(),
            dedicatedHostType = javaType.dedicatedHostType(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            gpuSpec = javaType.gpuSpec(),
            id = javaType.id(),
            machineId = javaType.machineId(),
            networkAttributes = javaType.networkAttributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsHostNetworkAttribute.Companion.toKotlin(args0)
                })
            }),
            operationLocks = javaType.operationLocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsHostOperationLock.Companion.toKotlin(args0)
                })
            }),
            paymentType = javaType.paymentType(),
            physicalGpus = javaType.physicalGpus(),
            resourceGroupId = javaType.resourceGroupId(),
            saleCycle = javaType.saleCycle(),
            sockets = javaType.sockets(),
            status = javaType.status(),
            supportedCustomInstanceTypeFamilies = javaType.supportedCustomInstanceTypeFamilies().map({ args0 ->
                args0
            }),
            supportedInstanceTypeFamilies = javaType.supportedInstanceTypeFamilies().map({ args0 -> args0 }),
            supportedInstanceTypesLists = javaType.supportedInstanceTypesLists().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            zoneId = javaType.zoneId(),
        )
    }
}
