@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availableLocalStorage The remaining local disk capacity. Unit: GiB.
 * @property availableMemory The remaining memory capacity, unit: GiB.
 * @property availableVcpus The number of remaining vCPU cores.
 * @property availableVgpus The number of available virtual GPUs.
 * @property localStorageCategory Local disk type.
 * @property totalLocalStorage The total capacity of the local disk, in GiB.
 * @property totalMemory The total memory capacity, unit: GiB.
 * @property totalVcpus The total number of vCPU cores.
 * @property totalVgpus The total number of virtual GPUs.
 */
public data class GetDedicatedHostsHostCapacity(
    public val availableLocalStorage: Int,
    public val availableMemory: Double,
    public val availableVcpus: Int,
    public val availableVgpus: Int,
    public val localStorageCategory: String,
    public val totalLocalStorage: Int,
    public val totalMemory: Double,
    public val totalVcpus: Int,
    public val totalVgpus: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetDedicatedHostsHostCapacity): GetDedicatedHostsHostCapacity = GetDedicatedHostsHostCapacity(
            availableLocalStorage = javaType.availableLocalStorage(),
            availableMemory = javaType.availableMemory(),
            availableVcpus = javaType.availableVcpus(),
            availableVgpus = javaType.availableVgpus(),
            localStorageCategory = javaType.localStorageCategory(),
            totalLocalStorage = javaType.totalLocalStorage(),
            totalMemory = javaType.totalMemory(),
            totalVcpus = javaType.totalVcpus(),
            totalVgpus = javaType.totalVgpus(),
        )
    }
}
