@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property slbUdpTimeout The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds.
 * @property udpTimeout (Available in 1.123.1+) The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds.
 */
public data class GetDedicatedHostsHostNetworkAttribute(
    public val slbUdpTimeout: Int,
    public val udpTimeout: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetDedicatedHostsHostNetworkAttribute): GetDedicatedHostsHostNetworkAttribute = GetDedicatedHostsHostNetworkAttribute(
            slbUdpTimeout = javaType.slbUdpTimeout(),
            udpTimeout = javaType.udpTimeout(),
        )
    }
}
