@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDedicatedHosts.
 * @property dedicatedHostId ID of the ECS Dedicated Host.
 * @property dedicatedHostName The name of the dedicated host.
 * @property dedicatedHostType The type of the dedicated host.
 * @property hosts A list of ECS Dedicated Hosts. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of ECS Dedicated Host ids.
 * @property nameRegex
 * @property names A list of ECS Dedicated Host names.
 * @property operationLocks (Available in 1.123.1+) The operation_locks. contains the following attribute:
 * @property outputFile
 * @property resourceGroupId The ID of the resource group to which the dedicated host belongs.
 * @property status The service status of the dedicated host.
 * @property tags
 * @property zoneId
 */
public data class GetDedicatedHostsResult(
    public val dedicatedHostId: String? = null,
    public val dedicatedHostName: String? = null,
    public val dedicatedHostType: String? = null,
    public val hosts: List<GetDedicatedHostsHost>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val operationLocks: List<GetDedicatedHostsOperationLock>? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetDedicatedHostsResult): GetDedicatedHostsResult = GetDedicatedHostsResult(
            dedicatedHostId = javaType.dedicatedHostId().map({ args0 -> args0 }).orElse(null),
            dedicatedHostName = javaType.dedicatedHostName().map({ args0 -> args0 }).orElse(null),
            dedicatedHostType = javaType.dedicatedHostType().map({ args0 -> args0 }).orElse(null),
            hosts = javaType.hosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsHost.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            operationLocks = javaType.operationLocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsOperationLock.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
