@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property attachedTime Disk attachment time.
 * @property autoSnapshotPolicyId
 * @property availabilityZone Availability zone of the disk.
 * @property category Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk), `cloud_essd_entry`.
 * @property creationTime Disk creation time.
 * @property deleteAutoSnapshot
 * @property deleteWithInstance
 * @property description Disk description.
 * @property detachedTime Disk detachment time.
 * @property device
 * @property diskId
 * @property diskName
 * @property diskType
 * @property enableAutoSnapshot
 * @property enableAutomatedSnapshotPolicy
 * @property encrypted Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
 * @property expiredTime
 * @property id ID of the disk.
 * @property imageId ID of the image from which the disk is created. It is null unless the disk is created using an image.
 * @property instanceId Filter the results by the specified ECS instance ID.
 * @property iops
 * @property iopsRead
 * @property iopsWrite
 * @property kmsKeyId
 * @property mountInstanceNum
 * @property mountInstances
 * @property name Disk name.
 * @property operationLocks
 * @property paymentType
 * @property performanceLevel
 * @property portable
 * @property productCode
 * @property regionId Region ID the disk belongs to.
 * @property resourceGroupId The Id of resource group which the disk belongs.
 * @property size Disk size in GiB.
 * @property snapshotId Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
 * @property status Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
 * @property tags A map of tags assigned to the disks. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const disksDs = alicloud.ecs.getDisks({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * disks_ds = alicloud.ecs.get_disks(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disksDs = AliCloud.Ecs.GetDisks.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.GetDisks(ctx, &ecs.GetDisksArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetDisksArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var disksDs = EcsFunctions.getDisks(GetDisksArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   disksDs:
 *     fn::invoke:
 *       Function: alicloud:ecs:getDisks
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property type Disk type. Possible values: `system` and `data`.
 * @property zoneId
 */
public data class GetDisksDisk(
    public val attachedTime: String,
    public val autoSnapshotPolicyId: String,
    public val availabilityZone: String,
    public val category: String,
    public val creationTime: String,
    public val deleteAutoSnapshot: Boolean,
    public val deleteWithInstance: Boolean,
    public val description: String,
    public val detachedTime: String,
    public val device: String,
    public val diskId: String,
    public val diskName: String,
    public val diskType: String,
    public val enableAutoSnapshot: Boolean,
    public val enableAutomatedSnapshotPolicy: Boolean,
    public val encrypted: String,
    public val expiredTime: String,
    public val id: String,
    public val imageId: String,
    public val instanceId: String,
    public val iops: Int,
    public val iopsRead: Int,
    public val iopsWrite: Int,
    public val kmsKeyId: String,
    public val mountInstanceNum: Int,
    public val mountInstances: List<GetDisksDiskMountInstance>,
    public val name: String,
    public val operationLocks: List<GetDisksDiskOperationLock>,
    public val paymentType: String,
    public val performanceLevel: String,
    public val portable: Boolean,
    public val productCode: String,
    public val regionId: String,
    public val resourceGroupId: String,
    public val size: Int,
    public val snapshotId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetDisksDisk): GetDisksDisk =
            GetDisksDisk(
                attachedTime = javaType.attachedTime(),
                autoSnapshotPolicyId = javaType.autoSnapshotPolicyId(),
                availabilityZone = javaType.availabilityZone(),
                category = javaType.category(),
                creationTime = javaType.creationTime(),
                deleteAutoSnapshot = javaType.deleteAutoSnapshot(),
                deleteWithInstance = javaType.deleteWithInstance(),
                description = javaType.description(),
                detachedTime = javaType.detachedTime(),
                device = javaType.device(),
                diskId = javaType.diskId(),
                diskName = javaType.diskName(),
                diskType = javaType.diskType(),
                enableAutoSnapshot = javaType.enableAutoSnapshot(),
                enableAutomatedSnapshotPolicy = javaType.enableAutomatedSnapshotPolicy(),
                encrypted = javaType.encrypted(),
                expiredTime = javaType.expiredTime(),
                id = javaType.id(),
                imageId = javaType.imageId(),
                instanceId = javaType.instanceId(),
                iops = javaType.iops(),
                iopsRead = javaType.iopsRead(),
                iopsWrite = javaType.iopsWrite(),
                kmsKeyId = javaType.kmsKeyId(),
                mountInstanceNum = javaType.mountInstanceNum(),
                mountInstances = javaType.mountInstances().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetDisksDiskMountInstance.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                operationLocks = javaType.operationLocks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetDisksDiskOperationLock.Companion.toKotlin(args0)
                    })
                }),
                paymentType = javaType.paymentType(),
                performanceLevel = javaType.performanceLevel(),
                portable = javaType.portable(),
                productCode = javaType.productCode(),
                regionId = javaType.regionId(),
                resourceGroupId = javaType.resourceGroupId(),
                size = javaType.size(),
                snapshotId = javaType.snapshotId(),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
                zoneId = javaType.zoneId(),
            )
    }
}
