@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDisks.
 * @property additionalAttributes
 * @property autoSnapshotPolicyId
 * @property availabilityZone Availability zone of the disk.
 * @property category Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk).
 * @property deleteAutoSnapshot
 * @property deleteWithInstance
 * @property diskName
 * @property diskType
 * @property disks A list of disks. Each element contains the following attributes:
 * @property dryRun
 * @property enableAutoSnapshot
 * @property enableAutomatedSnapshotPolicy
 * @property enableShared
 * @property encrypted Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId ID of the related instance. It is `null` unless the `status` is `In_use`.
 * @property kmsKeyId
 * @property nameRegex
 * @property names
 * @property operationLocks
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property paymentType
 * @property portable
 * @property resourceGroupId The Id of resource group.
 * @property snapshotId Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
 * @property status Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
 * @property tags A map of tags assigned to the disk.
 * @property totalCount
 * @property type Disk type. Possible values: `system` and `data`.
 * @property zoneId
 */
public data class GetDisksResult(
    public val additionalAttributes: List<String>? = null,
    public val autoSnapshotPolicyId: String? = null,
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: String? = null,
    public val category: String? = null,
    public val deleteAutoSnapshot: Boolean? = null,
    public val deleteWithInstance: Boolean? = null,
    public val diskName: String? = null,
    public val diskType: String? = null,
    public val disks: List<GetDisksDisk>,
    public val dryRun: Boolean? = null,
    public val enableAutoSnapshot: Boolean? = null,
    public val enableAutomatedSnapshotPolicy: Boolean? = null,
    public val enableShared: Boolean? = null,
    public val encrypted: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val kmsKeyId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val operationLocks: List<GetDisksOperationLock>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val portable: Boolean? = null,
    public val resourceGroupId: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.122.0. New field 'disk_type' instead.
  """,
    )
    public val type: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetDisksResult): GetDisksResult =
            GetDisksResult(
                additionalAttributes = javaType.additionalAttributes().map({ args0 -> args0 }),
                autoSnapshotPolicyId = javaType.autoSnapshotPolicyId().map({ args0 -> args0 }).orElse(null),
                availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
                category = javaType.category().map({ args0 -> args0 }).orElse(null),
                deleteAutoSnapshot = javaType.deleteAutoSnapshot().map({ args0 -> args0 }).orElse(null),
                deleteWithInstance = javaType.deleteWithInstance().map({ args0 -> args0 }).orElse(null),
                diskName = javaType.diskName().map({ args0 -> args0 }).orElse(null),
                diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
                disks = javaType.disks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetDisksDisk.Companion.toKotlin(args0)
                    })
                }),
                dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
                enableAutoSnapshot = javaType.enableAutoSnapshot().map({ args0 -> args0 }).orElse(null),
                enableAutomatedSnapshotPolicy = javaType.enableAutomatedSnapshotPolicy().map({ args0 ->
                    args0
                }).orElse(null),
                enableShared = javaType.enableShared().map({ args0 -> args0 }).orElse(null),
                encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                operationLocks = javaType.operationLocks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetDisksOperationLock.Companion.toKotlin(args0)
                    })
                }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
                pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
                paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
                portable = javaType.portable().map({ args0 -> args0 }).orElse(null),
                resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
                snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                totalCount = javaType.totalCount(),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
