@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property dedicatedHostClusterCapacities The capacity of the dedicated host cluster.
 * @property dedicatedHostClusterId The ID of the dedicated host cluster.
 * @property dedicatedHostClusterName The name of the dedicated host cluster.
 * @property dedicatedHostIds The IDs of dedicated hosts in the dedicated host cluster.
 * @property description The description of the dedicated host cluster.
 * @property id The ID of the Dedicated Host Cluster.
 * @property resourceGroupId The ID of the resource group to which the dedicated host cluster belongs.
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The zone ID of the dedicated host cluster.
 */
public data class GetEcsDedicatedHostClustersCluster(
    public val dedicatedHostClusterCapacities: List<GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacity>,
    public val dedicatedHostClusterId: String,
    public val dedicatedHostClusterName: String,
    public val dedicatedHostIds: List<String>,
    public val description: String,
    public val id: String,
    public val resourceGroupId: String,
    public val tags: Map<String, String>,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsDedicatedHostClustersCluster): GetEcsDedicatedHostClustersCluster = GetEcsDedicatedHostClustersCluster(
            dedicatedHostClusterCapacities = javaType.dedicatedHostClusterCapacities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacity.Companion.toKotlin(args0)
                })
            }),
            dedicatedHostClusterId = javaType.dedicatedHostClusterId(),
            dedicatedHostClusterName = javaType.dedicatedHostClusterName(),
            dedicatedHostIds = javaType.dedicatedHostIds().map({ args0 -> args0 }),
            description = javaType.description(),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            zoneId = javaType.zoneId(),
        )
    }
}
