@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availableMemory The available memory size. Unit: `GiB`.
 * @property availableVcpus The number of available vCPUs.
 * @property localStorageCapacities The local storage.
 * @property totalMemory The total memory size. Unit: `GiB`.
 * @property totalVcpus The total number of vCPUs.
 */
public data class GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacity(
    public val availableMemory: Int,
    public val availableVcpus: Int,
    public val localStorageCapacities: List<GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacity>,
    public val totalMemory: Int,
    public val totalVcpus: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacity): GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacity =
            GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacity(
                availableMemory = javaType.availableMemory(),
                availableVcpus = javaType.availableVcpus(),
                localStorageCapacities = javaType.localStorageCapacities().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacity.Companion.toKotlin(args0)
                    })
                }),
                totalMemory = javaType.totalMemory(),
                totalVcpus = javaType.totalVcpus(),
            )
    }
}
