@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEcsDedicatedHostClusters.
 * @property clusters
 * @property dedicatedHostClusterIds
 * @property dedicatedHostClusterName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property tags
 * @property zoneId
 */
public data class GetEcsDedicatedHostClustersResult(
    public val clusters: List<GetEcsDedicatedHostClustersCluster>,
    public val dedicatedHostClusterIds: List<String>? = null,
    public val dedicatedHostClusterName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsDedicatedHostClustersResult): GetEcsDedicatedHostClustersResult = GetEcsDedicatedHostClustersResult(
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDedicatedHostClustersCluster.Companion.toKotlin(args0)
                })
            }),
            dedicatedHostClusterIds = javaType.dedicatedHostClusterIds().map({ args0 -> args0 }),
            dedicatedHostClusterName = javaType.dedicatedHostClusterName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
