@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEcsDeploymentSets.
 * @property deploymentSetName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property sets
 * @property strategy
 */
public data class GetEcsDeploymentSetsResult(
    public val deploymentSetName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val sets: List<GetEcsDeploymentSetsSet>,
    public val strategy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsDeploymentSetsResult): GetEcsDeploymentSetsResult = GetEcsDeploymentSetsResult(
            deploymentSetName = javaType.deploymentSetName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sets = javaType.sets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDeploymentSetsSet.Companion.toKotlin(args0)
                })
            }),
            strategy = javaType.strategy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
