@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The time when the deployment set was created.
 * @property deploymentSetId The ID of the Deployment Set.
 * @property deploymentSetName The name of the deployment set.
 * @property description The description of the deployment set.
 * @property domain The deployment domain.
 * @property granularity The deployment granularity.
 * @property id The ID of the Deployment Set.
 * @property instanceAmount The number of instances in the deployment set.
 * @property instanceIds The IDs of the instances in the deployment set.
 * @property strategy The deployment strategy.
 */
public data class GetEcsDeploymentSetsSet(
    public val createTime: String,
    public val deploymentSetId: String,
    public val deploymentSetName: String,
    public val description: String,
    public val domain: String,
    public val granularity: String,
    public val id: String,
    public val instanceAmount: Int,
    public val instanceIds: List<String>,
    public val strategy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsDeploymentSetsSet): GetEcsDeploymentSetsSet = GetEcsDeploymentSetsSet(
            createTime = javaType.createTime(),
            deploymentSetId = javaType.deploymentSetId(),
            deploymentSetName = javaType.deploymentSetName(),
            description = javaType.description(),
            domain = javaType.domain(),
            granularity = javaType.granularity(),
            id = javaType.id(),
            instanceAmount = javaType.instanceAmount(),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            strategy = javaType.strategy(),
        )
    }
}
