@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property attachedTime Disk attachment time.
 * @property autoSnapshotPolicyId Query cloud disks based on the automatic snapshot policy ID.
 * @property availabilityZone Availability zone of the disk.
 * @property category Disk category.
 * @property creationTime Disk creation time.
 * @property deleteAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released.
 * @property deleteWithInstance Indicates whether the disk is released together with the instance.
 * @property description Disk description.
 * @property detachedTime Disk detachment time.
 * @property device Cloud disk or the device name of the mounted instance on the site.
 * @property diskId ID of the disk.
 * @property diskName The disk name.
 * @property diskType The disk type.
 * @property enableAutoSnapshot Whether the disk implements an automatic snapshot policy.
 * @property enableAutomatedSnapshotPolicy Whether the disk implements an automatic snapshot policy.
 * @property encrypted Indicate whether the disk is encrypted or not.
 * @property expiredTime
 * @property id ID of the disk.
 * @property imageId ID of the image from which the disk is created. It is null unless the disk is created using an image.
 * @property instanceId ID of the related instance. It is `null` unless the `status` is `In_use`.
 * @property iops
 * @property iopsRead
 * @property iopsWrite
 * @property kmsKeyId The kms key id.
 * @property mountInstanceNum Number of instances mounted on shared storage.
 * @property mountInstances Disk mount instances.
 * @property name Disk name.
 * @property operationLocks
 * @property paymentType Payment method for disk.
 * @property performanceLevel Performance levels of ESSD cloud disk.
 * @property portable Whether the disk is unmountable.
 * @property productCode The product logo of the cloud market.
 * @property regionId Region ID the disk belongs to.
 * @property resourceGroupId The Id of resource group.
 * @property size Disk size in GiB.
 * @property snapshotId Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
 * @property status Current status.
 * @property tags A map of tags assigned to the disk.
 * @property type Disk type.
 * @property zoneId The zone id.
 */
public data class GetEcsDisksDisk(
    public val attachedTime: String,
    public val autoSnapshotPolicyId: String,
    public val availabilityZone: String,
    public val category: String,
    public val creationTime: String,
    public val deleteAutoSnapshot: Boolean,
    public val deleteWithInstance: Boolean,
    public val description: String,
    public val detachedTime: String,
    public val device: String,
    public val diskId: String,
    public val diskName: String,
    public val diskType: String,
    public val enableAutoSnapshot: Boolean,
    public val enableAutomatedSnapshotPolicy: Boolean,
    public val encrypted: String,
    public val expiredTime: String,
    public val id: String,
    public val imageId: String,
    public val instanceId: String,
    public val iops: Int,
    public val iopsRead: Int,
    public val iopsWrite: Int,
    public val kmsKeyId: String,
    public val mountInstanceNum: Int,
    public val mountInstances: List<GetEcsDisksDiskMountInstance>,
    public val name: String,
    public val operationLocks: List<GetEcsDisksDiskOperationLock>,
    public val paymentType: String,
    public val performanceLevel: String,
    public val portable: Boolean,
    public val productCode: String,
    public val regionId: String,
    public val resourceGroupId: String,
    public val size: Int,
    public val snapshotId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsDisksDisk): GetEcsDisksDisk = GetEcsDisksDisk(
            attachedTime = javaType.attachedTime(),
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId(),
            availabilityZone = javaType.availabilityZone(),
            category = javaType.category(),
            creationTime = javaType.creationTime(),
            deleteAutoSnapshot = javaType.deleteAutoSnapshot(),
            deleteWithInstance = javaType.deleteWithInstance(),
            description = javaType.description(),
            detachedTime = javaType.detachedTime(),
            device = javaType.device(),
            diskId = javaType.diskId(),
            diskName = javaType.diskName(),
            diskType = javaType.diskType(),
            enableAutoSnapshot = javaType.enableAutoSnapshot(),
            enableAutomatedSnapshotPolicy = javaType.enableAutomatedSnapshotPolicy(),
            encrypted = javaType.encrypted(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            instanceId = javaType.instanceId(),
            iops = javaType.iops(),
            iopsRead = javaType.iopsRead(),
            iopsWrite = javaType.iopsWrite(),
            kmsKeyId = javaType.kmsKeyId(),
            mountInstanceNum = javaType.mountInstanceNum(),
            mountInstances = javaType.mountInstances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDisksDiskMountInstance.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            operationLocks = javaType.operationLocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDisksDiskOperationLock.Companion.toKotlin(args0)
                })
            }),
            paymentType = javaType.paymentType(),
            performanceLevel = javaType.performanceLevel(),
            portable = javaType.portable(),
            productCode = javaType.productCode(),
            regionId = javaType.regionId(),
            resourceGroupId = javaType.resourceGroupId(),
            size = javaType.size(),
            snapshotId = javaType.snapshotId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneId = javaType.zoneId(),
        )
    }
}
