@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property componentType The type of the image component.
 * @property content The content of the image component.
 * @property createTime The time when the image component was created.
 * @property description The description of the image component.
 * @property id The ID of the Image Component.
 * @property imageComponentId The ID of the image component.
 * @property imageComponentName The name of the image component.
 * @property owner The type of the image component.
 * @property resourceGroupId The ID of the resource group.
 * @property systemType The operating system type supported by the image component.
 * @property tags List of label key-value pairs.
 */
public data class GetEcsImageComponentsComponent(
    public val componentType: String,
    public val content: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val imageComponentId: String,
    public val imageComponentName: String,
    public val owner: String,
    public val resourceGroupId: String,
    public val systemType: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsImageComponentsComponent): GetEcsImageComponentsComponent = GetEcsImageComponentsComponent(
            componentType = javaType.componentType(),
            content = javaType.content(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            imageComponentId = javaType.imageComponentId(),
            imageComponentName = javaType.imageComponentName(),
            owner = javaType.owner(),
            resourceGroupId = javaType.resourceGroupId(),
            systemType = javaType.systemType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
