@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property addAccounts The IDs of Alibaba Cloud accounts to which the image was shared.
 * @property baseImage The source image.
 * @property baseImageType The type of the source image.
 * @property buildContent The content of the image template.
 * @property creationTime The time when the image template was created.
 * @property deleteInstanceOnFailure Indicates whether the intermediate instance was released when the image failed to be created.
 * @property description The description of the image template.
 * @property id The ID of the Image Pipeline.
 * @property imageName The name prefix of the created image.
 * @property imagePipelineId The ID of the image template.
 * @property instanceType The instance type of the intermediate instance.
 * @property internetMaxBandwidthOut The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`.
 * @property name The name of the image template.
 * @property resourceGroupId The ID of the resource group to which the image template belongs.
 * @property systemDiskSize The system disk size of the intermediate instance. Unit: `GiB`.
 * @property tags A mapping of tags to assign to the resource.
 * @property toRegionIds The IDs of regions to which to distribute the created image.
 * @property vswitchId The vswitch id.
 */
public data class GetEcsImagePipelinePipeline(
    public val addAccounts: List<String>,
    public val baseImage: String,
    public val baseImageType: String,
    public val buildContent: String,
    public val creationTime: String,
    public val deleteInstanceOnFailure: Boolean,
    public val description: String,
    public val id: String,
    public val imageName: String,
    public val imagePipelineId: String,
    public val instanceType: String,
    public val internetMaxBandwidthOut: Int,
    public val name: String,
    public val resourceGroupId: String,
    public val systemDiskSize: Int,
    public val tags: Map<String, String>? = null,
    public val toRegionIds: List<String>,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsImagePipelinePipeline): GetEcsImagePipelinePipeline = GetEcsImagePipelinePipeline(
            addAccounts = javaType.addAccounts().map({ args0 -> args0 }),
            baseImage = javaType.baseImage(),
            baseImageType = javaType.baseImageType(),
            buildContent = javaType.buildContent(),
            creationTime = javaType.creationTime(),
            deleteInstanceOnFailure = javaType.deleteInstanceOnFailure(),
            description = javaType.description(),
            id = javaType.id(),
            imageName = javaType.imageName(),
            imagePipelineId = javaType.imagePipelineId(),
            instanceType = javaType.instanceType(),
            internetMaxBandwidthOut = javaType.internetMaxBandwidthOut(),
            name = javaType.name(),
            resourceGroupId = javaType.resourceGroupId(),
            systemDiskSize = javaType.systemDiskSize(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            toRegionIds = javaType.toRegionIds().map({ args0 -> args0 }),
            vswitchId = javaType.vswitchId(),
        )
    }
}
