@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEcsImagePipeline.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property name
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pipelines
 * @property resourceGroupId
 * @property tags
 */
public data class GetEcsImagePipelineResult(
    public val id: String,
    public val ids: List<String>,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pipelines: List<GetEcsImagePipelinePipeline>,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsImagePipelineResult): GetEcsImagePipelineResult = GetEcsImagePipelineResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsImagePipelinePipeline.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
