@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commandContent The Base64-encoded command content.
 * @property commandId The ID of the command.
 * @property commandName The name of the command.
 * @property commandType The type of the command.
 * @property createTime The creation time of the resource.
 * @property frequency The schedule on which the recurring execution of the command takes place. For information about the value specifications, see [Cron expression](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/cron-expression).
 * @property id The ID of the Invocation.
 * @property invocationId The ID of the Invocation.
 * @property invocationStatus The overall execution state of the command. The value of this parameter depends on the execution states on all the involved instances.
 * @property invokeInstances Execute target instance set type.
 * @property invokeStatus The overall execution state of the command. **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
 * @property parameters The custom parameters in the command.
 * @property repeatMode Indicates the execution mode of the command.
 * @property timed Indicates whether the commands are to be automatically run.
 * @property username The username that was used to run the command on the instance.
 */
public data class GetEcsInvocationsInvocation(
    public val commandContent: String,
    public val commandId: String,
    public val commandName: String,
    public val commandType: String,
    public val createTime: String,
    public val frequency: String,
    public val id: String,
    public val invocationId: String,
    public val invocationStatus: String,
    public val invokeInstances: List<GetEcsInvocationsInvocationInvokeInstance>,
    public val invokeStatus: String,
    public val parameters: String,
    public val repeatMode: String,
    public val timed: Boolean,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsInvocationsInvocation): GetEcsInvocationsInvocation = GetEcsInvocationsInvocation(
            commandContent = javaType.commandContent(),
            commandId = javaType.commandId(),
            commandName = javaType.commandName(),
            commandType = javaType.commandType(),
            createTime = javaType.createTime(),
            frequency = javaType.frequency(),
            id = javaType.id(),
            invocationId = javaType.invocationId(),
            invocationStatus = javaType.invocationStatus(),
            invokeInstances = javaType.invokeInstances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsInvocationsInvocationInvokeInstance.Companion.toKotlin(args0)
                })
            }),
            invokeStatus = javaType.invokeStatus(),
            parameters = javaType.parameters(),
            repeatMode = javaType.repeatMode(),
            timed = javaType.timed(),
            username = javaType.username(),
        )
    }
}
