@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creationTime The start time of the execution.
 * @property dropped The size of truncated and discarded text when the value of the Output response parameter exceeds 24 KB in size.
 * @property errorCode
 * @property errorInfo Details about the reason why the command failed to be sent or run.
 * @property exitCode The exit code of the execution.
 * @property finishTime The end time of the execution.
 * @property instanceId The ID of the instance.
 * @property instanceInvokeStatus
 * @property invocationStatus The execution state on a single instance. Valid values: `Pending`, `Scheduled`, `Running`, `Success`, `Failed`, `Stopping`, `Stopped`, `PartialFailed`.
 * @property output The output of the command.
 * @property repeats The number of times that the command is run on the instance.
 * @property startTime The time when the command started to be run on the instance.
 * @property stopTime The time when the command stopped being run on the instance. If you call the StopInvocation operation to manually stop the execution, the value is the time when you call the operation.
 * @property timed Indicates whether the commands are to be automatically run.
 * * `error_code	` - The code that indicates why the command failed to be sent or run.
 * * `instance_invoke_status	` - **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
 * @property updateTime The time when the execution state was updated.
 */
public data class GetEcsInvocationsInvocationInvokeInstance(
    public val creationTime: String,
    public val dropped: Int,
    public val errorCode: String,
    public val errorInfo: String,
    public val exitCode: Int,
    public val finishTime: String,
    public val instanceId: String,
    public val instanceInvokeStatus: String,
    public val invocationStatus: String,
    public val output: String,
    public val repeats: Int,
    public val startTime: String,
    public val stopTime: String,
    public val timed: Boolean,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsInvocationsInvocationInvokeInstance): GetEcsInvocationsInvocationInvokeInstance = GetEcsInvocationsInvocationInvokeInstance(
            creationTime = javaType.creationTime(),
            dropped = javaType.dropped(),
            errorCode = javaType.errorCode(),
            errorInfo = javaType.errorInfo(),
            exitCode = javaType.exitCode(),
            finishTime = javaType.finishTime(),
            instanceId = javaType.instanceId(),
            instanceInvokeStatus = javaType.instanceInvokeStatus(),
            invocationStatus = javaType.invocationStatus(),
            output = javaType.output(),
            repeats = javaType.repeats(),
            startTime = javaType.startTime(),
            stopTime = javaType.stopTime(),
            timed = javaType.timed(),
            updateTime = javaType.updateTime(),
        )
    }
}
