@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEcsInvocations.
 * @property commandId
 * @property contentEncoding
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property invocations
 * @property invokeStatus
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetEcsInvocationsResult(
    public val commandId: String? = null,
    public val contentEncoding: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val invocations: List<GetEcsInvocationsInvocation>,
    public val invokeStatus: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsInvocationsResult): GetEcsInvocationsResult = GetEcsInvocationsResult(
            commandId = javaType.commandId().map({ args0 -> args0 }).orElse(null),
            contentEncoding = javaType.contentEncoding().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            invocations = javaType.invocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsInvocationsInvocation.Companion.toKotlin(args0)
                })
            }),
            invokeStatus = javaType.invokeStatus().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
