@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property fingerPrint The finger print of the key pair.
 * @property id The ID of the Key Pair.
 * @property instances A list of ECS instances that has been bound this key pair.
 * @property keyName The Key Pair Name.
 * @property keyPairName
 * @property resourceGroupId The Resource Group Id.
 * @property tags The tags.
 */
public data class GetEcsKeyPairsPair(
    public val fingerPrint: String,
    public val id: String,
    public val instances: List<GetEcsKeyPairsPairInstance>,
    public val keyName: String,
    public val keyPairName: String,
    public val resourceGroupId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsKeyPairsPair): GetEcsKeyPairsPair = GetEcsKeyPairsPair(
            fingerPrint = javaType.fingerPrint(),
            id = javaType.id(),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsKeyPairsPairInstance.Companion.toKotlin(args0)
                })
            }),
            keyName = javaType.keyName(),
            keyPairName = javaType.keyPairName(),
            resourceGroupId = javaType.resourceGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
