@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEcsKeyPairs.
 * @property fingerPrint
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyPairs
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pairs
 * @property resourceGroupId
 * @property tags
 */
public data class GetEcsKeyPairsResult(
    public val fingerPrint: String? = null,
    public val id: String,
    public val ids: List<String>,
    @Deprecated(
        message = """
  Field 'key_pairs' has been deprecated from provider version 1.121.0. New field 'pairs' instead.
  """,
    )
    public val keyPairs: List<GetEcsKeyPairsKeyPair>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pairs: List<GetEcsKeyPairsPair>,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsKeyPairsResult): GetEcsKeyPairsResult = GetEcsKeyPairsResult(
            fingerPrint = javaType.fingerPrint().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyPairs = javaType.keyPairs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsKeyPairsKeyPair.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pairs = javaType.pairs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsKeyPairsPair.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
