@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEcsLaunchTemplates.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property launchTemplateName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property templateResourceGroupId
 * @property templateTags
 * @property templates
 */
public data class GetEcsLaunchTemplatesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val launchTemplateName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val templateResourceGroupId: String? = null,
    public val templateTags: Map<String, String>? = null,
    public val templates: List<GetEcsLaunchTemplatesTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsLaunchTemplatesResult): GetEcsLaunchTemplatesResult = GetEcsLaunchTemplatesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            launchTemplateName = javaType.launchTemplateName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            templateResourceGroupId = javaType.templateResourceGroupId().map({ args0 -> args0 }).orElse(null),
            templateTags = javaType.templateTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsLaunchTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
