@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property autoReleaseTime Instance auto release time.
 * @property createdBy CreatedBy.
 * @property dataDisks The list of data disks created with instance.
 * @property defaultVersionNumber The Default Version Number.
 * @property deploymentSetId The Deployment Set Id.
 * @property description The Description of Template.
 * @property enableVmOsConfig Whether to enable the instance operating system configuration.
 * @property hostName Instance host name.
 * @property id The ID of the Launch Template.
 * @property imageId The Image Id.
 * @property imageOwnerAlias Mirror source.
 * @property instanceChargeType Internet bandwidth billing method.
 * @property instanceName The Instance Name.
 * @property instanceType Instance type.
 * @property internetChargeType Internet bandwidth billing method.
 * @property internetMaxBandwidthIn The maximum inbound bandwidth from the Internet network, measured in Mbit/s.
 * @property internetMaxBandwidthOut Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s.
 * @property ioOptimized Whether it is an I/O-optimized instance or not.
 * @property keyPairName The name of the key pair.
 * @property latestVersionNumber The Latest Version Number.
 * @property launchTemplateId The ID of the Launch Template.
 * @property launchTemplateName The Launch Template Name.
 * @property modifiedTime The Modified Time.
 * @property networkInterfaces The list of network interfaces created with instance.
 * @property networkType Network type of the instance.
 * @property passwordInherit Whether to use the password preset by the mirror.
 * @property period The subscription period of the instance.
 * @property privateIpAddress The private IP address of the instance.
 * @property ramRoleName The RAM role name of the instance.
 * @property resourceGroupId The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
 * @property securityEnhancementStrategy Whether or not to activate the security enhancement feature and install network security software free of charge.
 * @property securityGroupId The security group ID.
 * @property securityGroupIds The security group IDs.
 * @property spotDuration The protection period of the preemptible instance.
 * @property spotPriceLimit Sets the maximum hourly instance price.
 * @property spotStrategy The spot strategy for a Pay-As-You-Go instance.
 * @property systemDisks The System Disk.
 * @property templateTags The template tags.
 * @property userData The User Data.
 * @property versionDescription The Version Description.
 * @property vpcId VpcId.
 * @property vswitchId The vswitch id.
 * @property zoneId The Zone Id.
 */
public data class GetEcsLaunchTemplatesTemplate(
    public val autoReleaseTime: String,
    public val createdBy: String,
    public val dataDisks: List<GetEcsLaunchTemplatesTemplateDataDisk>,
    public val defaultVersionNumber: Int,
    public val deploymentSetId: String,
    public val description: String,
    public val enableVmOsConfig: Boolean,
    public val hostName: String,
    public val id: String,
    public val imageId: String,
    public val imageOwnerAlias: String,
    public val instanceChargeType: String,
    public val instanceName: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val internetMaxBandwidthIn: Int,
    public val internetMaxBandwidthOut: Int,
    public val ioOptimized: String,
    public val keyPairName: String,
    public val latestVersionNumber: Int,
    public val launchTemplateId: String,
    public val launchTemplateName: String,
    public val modifiedTime: String,
    public val networkInterfaces: List<GetEcsLaunchTemplatesTemplateNetworkInterface>,
    public val networkType: String,
    public val passwordInherit: Boolean,
    public val period: Int,
    public val privateIpAddress: String,
    public val ramRoleName: String,
    public val resourceGroupId: String,
    public val securityEnhancementStrategy: String,
    public val securityGroupId: String,
    public val securityGroupIds: List<String>,
    public val spotDuration: String,
    public val spotPriceLimit: Double,
    public val spotStrategy: String,
    public val systemDisks: List<GetEcsLaunchTemplatesTemplateSystemDisk>,
    public val templateTags: Map<String, String>,
    public val userData: String,
    public val versionDescription: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsLaunchTemplatesTemplate): GetEcsLaunchTemplatesTemplate = GetEcsLaunchTemplatesTemplate(
            autoReleaseTime = javaType.autoReleaseTime(),
            createdBy = javaType.createdBy(),
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsLaunchTemplatesTemplateDataDisk.Companion.toKotlin(args0)
                })
            }),
            defaultVersionNumber = javaType.defaultVersionNumber(),
            deploymentSetId = javaType.deploymentSetId(),
            description = javaType.description(),
            enableVmOsConfig = javaType.enableVmOsConfig(),
            hostName = javaType.hostName(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            imageOwnerAlias = javaType.imageOwnerAlias(),
            instanceChargeType = javaType.instanceChargeType(),
            instanceName = javaType.instanceName(),
            instanceType = javaType.instanceType(),
            internetChargeType = javaType.internetChargeType(),
            internetMaxBandwidthIn = javaType.internetMaxBandwidthIn(),
            internetMaxBandwidthOut = javaType.internetMaxBandwidthOut(),
            ioOptimized = javaType.ioOptimized(),
            keyPairName = javaType.keyPairName(),
            latestVersionNumber = javaType.latestVersionNumber(),
            launchTemplateId = javaType.launchTemplateId(),
            launchTemplateName = javaType.launchTemplateName(),
            modifiedTime = javaType.modifiedTime(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsLaunchTemplatesTemplateNetworkInterface.Companion.toKotlin(args0)
                })
            }),
            networkType = javaType.networkType(),
            passwordInherit = javaType.passwordInherit(),
            period = javaType.period(),
            privateIpAddress = javaType.privateIpAddress(),
            ramRoleName = javaType.ramRoleName(),
            resourceGroupId = javaType.resourceGroupId(),
            securityEnhancementStrategy = javaType.securityEnhancementStrategy(),
            securityGroupId = javaType.securityGroupId(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            spotDuration = javaType.spotDuration(),
            spotPriceLimit = javaType.spotPriceLimit(),
            spotStrategy = javaType.spotStrategy(),
            systemDisks = javaType.systemDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsLaunchTemplatesTemplateSystemDisk.Companion.toKotlin(args0)
                })
            }),
            templateTags = javaType.templateTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userData = javaType.userData(),
            versionDescription = javaType.versionDescription(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
