@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of the disk.
 * @property deleteWithInstance Indicates whether the data disk is released with the instance.
 * @property description The description of the data disk.
 * @property encrypted Encrypted the data in this disk.
 * @property name The name of the data disk.
 * @property performanceLevel PerformanceLevel.
 * @property size The performance level of the ESSD used as the data disk.
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class GetEcsLaunchTemplatesTemplateDataDisk(
    public val category: String,
    public val deleteWithInstance: Boolean,
    public val description: String,
    public val encrypted: Boolean,
    public val name: String,
    public val performanceLevel: String,
    public val size: Int,
    public val snapshotId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsLaunchTemplatesTemplateDataDisk): GetEcsLaunchTemplatesTemplateDataDisk = GetEcsLaunchTemplatesTemplateDataDisk(
            category = javaType.category(),
            deleteWithInstance = javaType.deleteWithInstance(),
            description = javaType.description(),
            encrypted = javaType.encrypted(),
            name = javaType.name(),
            performanceLevel = javaType.performanceLevel(),
            size = javaType.size(),
            snapshotId = javaType.snapshotId(),
        )
    }
}
