@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The ENI description.
 * @property name The ENI name.
 * @property primaryIp The primary private IP address of the ENI.
 * @property securityGroupId The security group ID must be one in the same VPC.
 * @property vswitchId The vSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
 */
public data class GetEcsLaunchTemplatesTemplateNetworkInterface(
    public val description: String,
    public val name: String,
    public val primaryIp: String,
    public val securityGroupId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsLaunchTemplatesTemplateNetworkInterface): GetEcsLaunchTemplatesTemplateNetworkInterface =
            GetEcsLaunchTemplatesTemplateNetworkInterface(
                description = javaType.description(),
                name = javaType.name(),
                primaryIp = javaType.primaryIp(),
                securityGroupId = javaType.securityGroupId(),
                vswitchId = javaType.vswitchId(),
            )
    }
}
