@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of the system disk.
 * @property deleteWithInstance Specifies whether to release the system disk when the instance is released.
 * @property description System disk description.
 * @property iops The Iops.
 * @property name System disk name.
 * @property performanceLevel The performance level of the ESSD used as the system disk.
 * @property size Size of the system disk, measured in GB.
 */
public data class GetEcsLaunchTemplatesTemplateSystemDisk(
    public val category: String,
    public val deleteWithInstance: Boolean,
    public val description: String,
    public val iops: String,
    public val name: String,
    public val performanceLevel: String,
    public val size: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsLaunchTemplatesTemplateSystemDisk): GetEcsLaunchTemplatesTemplateSystemDisk = GetEcsLaunchTemplatesTemplateSystemDisk(
            category = javaType.category(),
            deleteWithInstance = javaType.deleteWithInstance(),
            description = javaType.description(),
            iops = javaType.iops(),
            name = javaType.name(),
            performanceLevel = javaType.performanceLevel(),
            size = javaType.size(),
        )
    }
}
