@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
 * @property id The ID of the Network Interface Permission.
 * @property networkInterfaceId The ID of the network interface.
 * @property networkInterfacePermissionId The ID of the Network Interface Permissions.
 * @property permission The permissions of the Network Interface.
 * @property serviceName Alibaba Cloud service name.
 * @property status The Status of the Network Interface Permissions.
 */
public data class GetEcsNetworkInterfacePermissionsPermission(
    public val accountId: String,
    public val id: String,
    public val networkInterfaceId: String,
    public val networkInterfacePermissionId: String,
    public val permission: String,
    public val serviceName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsNetworkInterfacePermissionsPermission): GetEcsNetworkInterfacePermissionsPermission = GetEcsNetworkInterfacePermissionsPermission(
            accountId = javaType.accountId(),
            id = javaType.id(),
            networkInterfaceId = javaType.networkInterfaceId(),
            networkInterfacePermissionId = javaType.networkInterfacePermissionId(),
            permission = javaType.permission(),
            serviceName = javaType.serviceName(),
            status = javaType.status(),
        )
    }
}
