@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEcsNetworkInterfacePermissions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property networkInterfaceId
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property permissions
 * @property status
 * @property totalCount
 */
public data class GetEcsNetworkInterfacePermissionsResult(
    public val id: String,
    public val ids: List<String>,
    public val networkInterfaceId: String,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val permissions: List<GetEcsNetworkInterfacePermissionsPermission>,
    public val status: String? = null,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsNetworkInterfacePermissionsResult): GetEcsNetworkInterfacePermissionsResult = GetEcsNetworkInterfacePermissionsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            networkInterfaceId = javaType.networkInterfaceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            permissions = javaType.permissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacePermissionsPermission.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            totalCount = javaType.totalCount(),
        )
    }
}
