@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property associatedPublicIps The EIP associated with the secondary private IP address of the ENI.  **NOTE:** Available in v1.163.0+.
 * @property creationTime The creation time.
 * @property description The description of the ENI.
 * @property id The ID of the Network Interface.
 * @property instanceId The instance id.
 * @property ipv6Sets A list of IPv6 addresses that is assigned to the ENI.  **NOTE:** Available since v1.228.0.
 * @property mac The MAC address of the ENI.
 * @property name Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
 * @property networkInterfaceId The network interface id.
 * @property networkInterfaceName The network interface name.
 * @property networkInterfaceTrafficMode The communication mode of the elastic network card.
 * @property ownerId The ID of the account to which the ENIC belongs.
 * @property primaryIpAddress The primary private IP address of the ENI.
 * @property privateIp Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
 * @property privateIpAddresses A list of secondary private IP address that is assigned to the ENI.
 * @property privateIps A list of secondary private IP address that is assigned to the ENI.
 * @property queueNumber Number of network card queues.
 * @property resourceGroupId The resource group id.
 * @property securityGroupIds The security group ids.
 * @property securityGroups The security groups.
 * @property serviceId The service id.
 * @property serviceManaged Whether the user of the elastic network card is a cloud product or a virtual vendor.
 * @property status The status of ENI. Valid Values: `Attaching`, `Available`, `CreateFailed`, `Creating`, `Deleting`, `Detaching`, `InUse`, `Linked`, `Linking`, `Unlinking`.
 * @property tags A map of tags assigned to ENIs.
 * @property type The type of ENI. Valid Values: `Primary`, `Secondary`.
 * @property vpcId The vpc id.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone id.
 */
public data class GetEcsNetworkInterfacesInterface(
    public val associatedPublicIps: List<GetEcsNetworkInterfacesInterfaceAssociatedPublicIp>,
    public val creationTime: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val ipv6Sets: List<String>,
    public val mac: String,
    public val name: String,
    public val networkInterfaceId: String,
    public val networkInterfaceName: String,
    public val networkInterfaceTrafficMode: String,
    public val ownerId: String,
    public val primaryIpAddress: String,
    public val privateIp: String,
    public val privateIpAddresses: List<String>,
    public val privateIps: List<String>,
    public val queueNumber: Int,
    public val resourceGroupId: String,
    public val securityGroupIds: List<String>,
    public val securityGroups: List<String>,
    public val serviceId: Int,
    public val serviceManaged: Boolean,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsNetworkInterfacesInterface): GetEcsNetworkInterfacesInterface = GetEcsNetworkInterfacesInterface(
            associatedPublicIps = javaType.associatedPublicIps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacesInterfaceAssociatedPublicIp.Companion.toKotlin(args0)
                })
            }),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            ipv6Sets = javaType.ipv6Sets().map({ args0 -> args0 }),
            mac = javaType.mac(),
            name = javaType.name(),
            networkInterfaceId = javaType.networkInterfaceId(),
            networkInterfaceName = javaType.networkInterfaceName(),
            networkInterfaceTrafficMode = javaType.networkInterfaceTrafficMode(),
            ownerId = javaType.ownerId(),
            primaryIpAddress = javaType.primaryIpAddress(),
            privateIp = javaType.privateIp(),
            privateIpAddresses = javaType.privateIpAddresses().map({ args0 -> args0 }),
            privateIps = javaType.privateIps().map({ args0 -> args0 }),
            queueNumber = javaType.queueNumber(),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            serviceId = javaType.serviceId(),
            serviceManaged = javaType.serviceManaged(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
