@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEcsNetworkInterfaces.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId The instance id.
 * @property interfaces A list of Ecs Network Interfaces. Each element contains the following attributes:
 * @property name The network interface name.
 * @property nameRegex
 * @property names A list of Network Interface names.
 * @property networkInterfaceName The network interface name.
 * @property outputFile
 * @property primaryIpAddress The primary private IP address of the ENI.
 * @property privateIp The primary private IP address of the ENI.
 * @property resourceGroupId The resource group id.
 * @property securityGroupId
 * @property serviceManaged Whether the user of the elastic network card is a cloud product or a virtual vendor.
 * @property status The status of the ENI.
 * @property tags The tags.
 * @property type The type of the ENI.
 * @property vpcId The Vpc Id.
 * @property vswitchId The vswitch id.
 */
public data class GetEcsNetworkInterfacesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val interfaces: List<GetEcsNetworkInterfacesInterface>,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val networkInterfaceName: String? = null,
    public val outputFile: String? = null,
    public val primaryIpAddress: String? = null,
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    public val privateIp: String? = null,
    public val resourceGroupId: String? = null,
    public val securityGroupId: String? = null,
    public val serviceManaged: Boolean? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsNetworkInterfacesResult): GetEcsNetworkInterfacesResult = GetEcsNetworkInterfacesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            interfaces = javaType.interfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacesInterface.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            networkInterfaceName = javaType.networkInterfaceName().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            primaryIpAddress = javaType.primaryIpAddress().map({ args0 -> args0 }).orElse(null),
            privateIp = javaType.privateIp().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            serviceManaged = javaType.serviceManaged().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
