@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property addressFamily The address family of the prefix list. Valid values:`IPv4`,`IPv6`.
 * @property associationCount The amount of associated resources.
 * @property createTime The time when the prefix list was created.
 * @property description The description of the prefix list.
 * @property entries
 * @property id The ID of the prefix list.
 * @property maxEntries The maximum number of entries that the prefix list supports.
 * @property prefixListId The ID of the prefix list.
 * @property prefixListName The name of the prefix list.
 */
public data class GetEcsPrefixListsList(
    public val addressFamily: String,
    public val associationCount: Int,
    public val createTime: String,
    public val description: String,
    public val entries: List<GetEcsPrefixListsListEntry>,
    public val id: String,
    public val maxEntries: Int,
    public val prefixListId: String,
    public val prefixListName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsPrefixListsList): GetEcsPrefixListsList = GetEcsPrefixListsList(
            addressFamily = javaType.addressFamily(),
            associationCount = javaType.associationCount(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsPrefixListsListEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            maxEntries = javaType.maxEntries(),
            prefixListId = javaType.prefixListId(),
            prefixListName = javaType.prefixListName(),
        )
    }
}
