@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property description The description of the snapshot-consistent group.
 * @property id The ID of the Snapshot Group.
 * @property instanceId The ID of the instance.
 * @property resourceGroupId The ID of the resource group to which the snapshot consistency group belongs.
 * @property snapshotGroupId The first ID of the resource.
 * @property snapshotGroupName The name of the snapshot-consistent group.
 * @property status The status of the resource.
 * @property tags List of label key-value pairs.
 */
public data class GetEcsSnapshotGroupsGroup(
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val resourceGroupId: String,
    public val snapshotGroupId: String,
    public val snapshotGroupName: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsSnapshotGroupsGroup): GetEcsSnapshotGroupsGroup = GetEcsSnapshotGroupsGroup(
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            resourceGroupId = javaType.resourceGroupId(),
            snapshotGroupId = javaType.snapshotGroupId(),
            snapshotGroupName = javaType.snapshotGroupName(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
