@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEcsSnapshots.
 * @property category
 * @property dryRun
 * @property encrypted
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property kmsKeyId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property resourceGroupId
 * @property snapshotLinkId
 * @property snapshotName
 * @property snapshotType
 * @property snapshots
 * @property sourceDiskType
 * @property status
 * @property tags
 * @property type
 * @property usage
 */
public data class GetEcsSnapshotsResult(
    public val category: String? = null,
    public val dryRun: Boolean? = null,
    public val encrypted: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val kmsKeyId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val snapshotLinkId: String? = null,
    public val snapshotName: String? = null,
    public val snapshotType: String? = null,
    public val snapshots: List<GetEcsSnapshotsSnapshot>,
    public val sourceDiskType: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val usage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsSnapshotsResult): GetEcsSnapshotsResult = GetEcsSnapshotsResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            snapshotLinkId = javaType.snapshotLinkId().map({ args0 -> args0 }).orElse(null),
            snapshotName = javaType.snapshotName().map({ args0 -> args0 }).orElse(null),
            snapshotType = javaType.snapshotType().map({ args0 -> args0 }).orElse(null),
            snapshots = javaType.snapshots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsSnapshotsSnapshot.Companion.toKotlin(args0)
                })
            }),
            sourceDiskType = javaType.sourceDiskType().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            usage = javaType.usage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
