@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property category The category of the snapshot.
 * @property creationTime
 * @property description The description of the snapshot.
 * @property diskId The source disk id.
 * @property encrypted Whether the snapshot is encrypted.
 * @property id The ID of the Snapshot.
 * @property instantAccess Whether snapshot speed availability is enabled.
 * @property instantAccessRetentionDays Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
 * @property name
 * @property productCode The product number inherited from the mirror market.
 * @property progress Snapshot creation progress, in percentage.
 * @property remainTime Remaining completion time for the snapshot being created.
 * @property resourceGroupId The resource group id.
 * @property retentionDays Automatic snapshot retention days.
 * @property snapshotId The snapshot id.
 * @property snapshotName Snapshot Display Name.
 * @property snapshotSn The serial number of the snapshot.
 * @property snapshotType Snapshot creation type.
 * @property sourceDiskId
 * @property sourceDiskSize Source disk capacity.
 * @property sourceDiskType Source disk attributes.
 * @property sourceStorageType Original disk type.
 * @property status The status of the snapshot.
 * @property tags The tags.
 * @property type
 * @property usage A resource type that has a reference relationship.
 */
public data class GetEcsSnapshotsSnapshot(
    public val category: String,
    public val creationTime: String,
    public val description: String,
    public val diskId: String,
    public val encrypted: Boolean,
    public val id: String,
    public val instantAccess: Boolean,
    public val instantAccessRetentionDays: Int,
    public val name: String,
    public val productCode: String,
    public val progress: String,
    public val remainTime: Int,
    public val resourceGroupId: String,
    public val retentionDays: Int,
    public val snapshotId: String,
    public val snapshotName: String,
    public val snapshotSn: String,
    public val snapshotType: String,
    public val sourceDiskId: String,
    public val sourceDiskSize: String,
    public val sourceDiskType: String,
    public val sourceStorageType: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val usage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsSnapshotsSnapshot): GetEcsSnapshotsSnapshot = GetEcsSnapshotsSnapshot(
            category = javaType.category(),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            diskId = javaType.diskId(),
            encrypted = javaType.encrypted(),
            id = javaType.id(),
            instantAccess = javaType.instantAccess(),
            instantAccessRetentionDays = javaType.instantAccessRetentionDays(),
            name = javaType.name(),
            productCode = javaType.productCode(),
            progress = javaType.progress(),
            remainTime = javaType.remainTime(),
            resourceGroupId = javaType.resourceGroupId(),
            retentionDays = javaType.retentionDays(),
            snapshotId = javaType.snapshotId(),
            snapshotName = javaType.snapshotName(),
            snapshotSn = javaType.snapshotSn(),
            snapshotType = javaType.snapshotType(),
            sourceDiskId = javaType.sourceDiskId(),
            sourceDiskSize = javaType.sourceDiskSize(),
            sourceDiskType = javaType.sourceDiskType(),
            sourceStorageType = javaType.sourceStorageType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            usage = javaType.usage(),
        )
    }
}
