@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationStatus When the AllocationType value is Shared, this parameter indicates the allocation status of Storage Capacity Unit. Valid values: `allocated`, `Ignored`.
 * @property capacity The capacity of the Storage Capacity Unit.
 * @property createTime The time when the Storage Capacity Unit was created.
 * @property description The description of the Storage Capacity Unit.
 * @property expiredTime The time when the Storage Capacity Unit expires.
 * @property id The ID of the Storage Capacity Unit.
 * @property startTime The effective time of the Storage Capacity Unit.
 * @property status The status of Storage Capacity Unit.
 * @property storageCapacityUnitId The ID of Storage Capacity Unit.
 * @property storageCapacityUnitName The name of the Storage Capacity Unit.
 */
public data class GetEcsStorageCapacityUnitsUnit(
    public val allocationStatus: String,
    public val capacity: Int,
    public val createTime: String,
    public val description: String,
    public val expiredTime: String,
    public val id: String,
    public val startTime: String,
    public val status: String,
    public val storageCapacityUnitId: String,
    public val storageCapacityUnitName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEcsStorageCapacityUnitsUnit): GetEcsStorageCapacityUnitsUnit = GetEcsStorageCapacityUnitsUnit(
            allocationStatus = javaType.allocationStatus(),
            capacity = javaType.capacity(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            storageCapacityUnitId = javaType.storageCapacityUnitId(),
            storageCapacityUnitName = javaType.storageCapacityUnitName(),
        )
    }
}
