@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property addressName The name of the EIP.
 * @property allocationId The ID of the EIP.
 * @property availableRegions The ID of the region to which the EIP belongs.
 * @property bandwidth The maximum bandwidth of the EIP. Unit: Mbit/s.
 * @property bandwidthPackageBandwidth The bandwidth value of the EIP bandwidth plan with which the EIP is associated.
 * @property bandwidthPackageId The ID of the EIP bandwidth plan.
 * @property bandwidthPackageType The type of the bandwidth. Only CommonBandwidthPackage (an EIP bandwidth plan) is returned.
 * @property createTime The time when the EIP was created.
 * @property deletionProtection Indicates whether deletion protection is enabled.
 * @property description The description of the EIP.
 * @property expiredTime The expiration date. The time follows the ISO 8601 standard and is displayed in UTC. Format: YYYY-MM-DDThh:mmZ.
 * @property hasReservationData Indicates whether renewal data is included. This parameter returns true only when the parameter IncludeReservationData is set to true, and some orders have not taken effect.
 * @property hdMonitorStatus Indicates whether fine-grained monitoring is enabled for the EIP.
 * @property id The ID of the Address.
 * @property instanceId The ID of the instance with which the EIP is associated.
 * @property instanceRegionId The region ID of the associated resource.
 * @property instanceType The type of the instance with which the EIP is associated.
 * @property internetChargeType The metering method of the EIP.
 * @property ipAddress The IP address of the EIP.
 * @property isp The Internet service provider (ISP).
 * @property operationLocks The details about the locked EIP.
 * @property paymentType The billing method of the EIP.
 * @property reservationActiveTime The time when the renewal takes effect.
 * @property reservationBandwidth The bandwidth after the renewal takes effect.
 * @property reservationInternetChargeType The metering method of the renewal.
 * @property reservationOrderType The type of the renewal order.
 * @property resourceGroupId The ID of the resource group.
 * @property secondLimited Indicates whether level-2 throttling is configured.
 * @property segmentInstanceId The IDs of the contiguous EIPs.
 * @property status The status of the EIP.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetEipAddressesAddress(
    public val addressName: String,
    public val allocationId: String,
    public val availableRegions: List<String>,
    public val bandwidth: String,
    public val bandwidthPackageBandwidth: String,
    public val bandwidthPackageId: String,
    public val bandwidthPackageType: String,
    public val createTime: String,
    public val deletionProtection: Boolean,
    public val description: String,
    public val expiredTime: String,
    public val hasReservationData: String,
    public val hdMonitorStatus: String,
    public val id: String,
    public val instanceId: String,
    public val instanceRegionId: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val ipAddress: String,
    public val isp: String,
    public val operationLocks: List<String>,
    public val paymentType: String,
    public val reservationActiveTime: String,
    public val reservationBandwidth: String,
    public val reservationInternetChargeType: String,
    public val reservationOrderType: String,
    public val resourceGroupId: String,
    public val secondLimited: Boolean,
    public val segmentInstanceId: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEipAddressesAddress): GetEipAddressesAddress = GetEipAddressesAddress(
            addressName = javaType.addressName(),
            allocationId = javaType.allocationId(),
            availableRegions = javaType.availableRegions().map({ args0 -> args0 }),
            bandwidth = javaType.bandwidth(),
            bandwidthPackageBandwidth = javaType.bandwidthPackageBandwidth(),
            bandwidthPackageId = javaType.bandwidthPackageId(),
            bandwidthPackageType = javaType.bandwidthPackageType(),
            createTime = javaType.createTime(),
            deletionProtection = javaType.deletionProtection(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            hasReservationData = javaType.hasReservationData(),
            hdMonitorStatus = javaType.hdMonitorStatus(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceRegionId = javaType.instanceRegionId(),
            instanceType = javaType.instanceType(),
            internetChargeType = javaType.internetChargeType(),
            ipAddress = javaType.ipAddress(),
            isp = javaType.isp(),
            operationLocks = javaType.operationLocks().map({ args0 -> args0 }),
            paymentType = javaType.paymentType(),
            reservationActiveTime = javaType.reservationActiveTime(),
            reservationBandwidth = javaType.reservationBandwidth(),
            reservationInternetChargeType = javaType.reservationInternetChargeType(),
            reservationOrderType = javaType.reservationOrderType(),
            resourceGroupId = javaType.resourceGroupId(),
            secondLimited = javaType.secondLimited(),
            segmentInstanceId = javaType.segmentInstanceId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
