@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The maximum bandwidth of the EIP. Unit: Mbit/s.
 * @property creationTime
 * @property deletionProtection Indicates whether deletion protection is enabled.
 * @property id The ID of the Address.
 * @property instanceId The ID of the instance with which the EIP is associated.
 * @property instanceType The type of the instance with which the EIP is associated.
 * @property internetChargeType The metering method of the EIP.
 * @property ipAddress The eip address.
 * @property status The status of the EIP. Valid values:  `Associating`: The EIP is being associated. `Unassociating`: The EIP is being disassociated. `InUse`: The EIP is allocated. `Available`:The EIP is available.
 */
public data class GetEipAddressesEip(
    public val bandwidth: String,
    public val creationTime: String,
    public val deletionProtection: Boolean,
    public val id: String,
    public val instanceId: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val ipAddress: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEipAddressesEip): GetEipAddressesEip = GetEipAddressesEip(
            bandwidth = javaType.bandwidth(),
            creationTime = javaType.creationTime(),
            deletionProtection = javaType.deletionProtection(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceType = javaType.instanceType(),
            internetChargeType = javaType.internetChargeType(),
            ipAddress = javaType.ipAddress(),
            status = javaType.status(),
        )
    }
}
