@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property addressName
 * @property allocationId
 * @property availableRegions
 * @property bandwidth EIP internet max bandwidth in Mbps.
 * @property bandwidthPackageBandwidth
 * @property bandwidthPackageId
 * @property bandwidthPackageType
 * @property createTime
 * @property deletionProtection (Optional, Available in v1.124.4+) Whether enable the deletion protection or not.
 * @property description
 * @property expiredTime
 * @property hasReservationData
 * @property hdMonitorStatus
 * @property id ID of the EIP.
 * @property instanceId The ID of the instance that is being bound.
 * @property instanceRegionId
 * @property instanceType The instance type of that the EIP is bound.
 * @property internetChargeType EIP internet charge type.
 * @property ipAddress Public IP Address of the the EIP.
 * @property isp
 * @property operationLocks
 * @property paymentType
 * @property reservationActiveTime
 * @property reservationBandwidth
 * @property reservationInternetChargeType
 * @property reservationOrderType
 * @property resourceGroupId The Id of resource group which the eips belongs.
 * @property secondLimited
 * @property segmentInstanceId
 * @property status EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetEipsAddress(
    public val addressName: String,
    public val allocationId: String,
    public val availableRegions: List<String>,
    public val bandwidth: String,
    public val bandwidthPackageBandwidth: String,
    public val bandwidthPackageId: String,
    public val bandwidthPackageType: String,
    public val createTime: String,
    public val deletionProtection: Boolean,
    public val description: String,
    public val expiredTime: String,
    public val hasReservationData: String,
    public val hdMonitorStatus: String,
    public val id: String,
    public val instanceId: String,
    public val instanceRegionId: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val ipAddress: String,
    public val isp: String,
    public val operationLocks: List<String>,
    public val paymentType: String,
    public val reservationActiveTime: String,
    public val reservationBandwidth: String,
    public val reservationInternetChargeType: String,
    public val reservationOrderType: String,
    public val resourceGroupId: String,
    public val secondLimited: Boolean,
    public val segmentInstanceId: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEipsAddress): GetEipsAddress =
            GetEipsAddress(
                addressName = javaType.addressName(),
                allocationId = javaType.allocationId(),
                availableRegions = javaType.availableRegions().map({ args0 -> args0 }),
                bandwidth = javaType.bandwidth(),
                bandwidthPackageBandwidth = javaType.bandwidthPackageBandwidth(),
                bandwidthPackageId = javaType.bandwidthPackageId(),
                bandwidthPackageType = javaType.bandwidthPackageType(),
                createTime = javaType.createTime(),
                deletionProtection = javaType.deletionProtection(),
                description = javaType.description(),
                expiredTime = javaType.expiredTime(),
                hasReservationData = javaType.hasReservationData(),
                hdMonitorStatus = javaType.hdMonitorStatus(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                instanceRegionId = javaType.instanceRegionId(),
                instanceType = javaType.instanceType(),
                internetChargeType = javaType.internetChargeType(),
                ipAddress = javaType.ipAddress(),
                isp = javaType.isp(),
                operationLocks = javaType.operationLocks().map({ args0 -> args0 }),
                paymentType = javaType.paymentType(),
                reservationActiveTime = javaType.reservationActiveTime(),
                reservationBandwidth = javaType.reservationBandwidth(),
                reservationInternetChargeType = javaType.reservationInternetChargeType(),
                reservationOrderType = javaType.reservationOrderType(),
                resourceGroupId = javaType.resourceGroupId(),
                secondLimited = javaType.secondLimited(),
                segmentInstanceId = javaType.segmentInstanceId(),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
