@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth EIP internet max bandwidth in Mbps.
 * @property creationTime Time of creation.
 * @property deletionProtection (Optional, Available in v1.124.4+) Whether enable the deletion protection or not.
 * @property id ID of the EIP.
 * @property instanceId The ID of the instance that is being bound.
 * @property instanceType The instance type of that the EIP is bound.
 * @property internetChargeType EIP internet charge type.
 * @property ipAddress Public IP Address of the the EIP.
 * @property status EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
 */
public data class GetEipsEip(
    public val bandwidth: String,
    public val creationTime: String,
    public val deletionProtection: Boolean,
    public val id: String,
    public val instanceId: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val ipAddress: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.GetEipsEip): GetEipsEip =
            GetEipsEip(
                bandwidth = javaType.bandwidth(),
                creationTime = javaType.creationTime(),
                deletionProtection = javaType.deletionProtection(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                instanceType = javaType.instanceType(),
                internetChargeType = javaType.internetChargeType(),
                ipAddress = javaType.ipAddress(),
                status = javaType.status(),
            )
    }
}
